set more off 
pause on
set logtype text
set mem 500M

tempfile tempmonth

*************** DESCRIPTION *************************************
* Aggregates FRED data to yearly level.
*
*	Inputs:  Fred_month, FRED_quarter and FRED_annual from A_fred_datawork
*	Outputs: 2.intermediate\fred_mapped
*****************************************************************

use 0.raw_inputs\fred_month, clear
sort year month

foreach X in p_cpi r_aaa r_baa unr r_tb3m r_gs1 r_gs10 unr emprate_civil hw_prod htot_prod pop {
egen temp = mean(`X'), by(year)
replace `X'=temp
drop temp
}

bys year: keep if _n==1
compress
sort year
save `tempmonth', replace

*** ADD QUARTERLY DATA ***
use 0.raw_inputs\fred_quarter, clear
sort year qtr
drop if qtr ~= 4
drop qtr
merge 1:1 year using `tempmonth', nogen 

merge 1:1 year using 0.raw_inputs\fred_annual, nogen

compress
sort year 
save 2.intermediate\fred_mapped, replace
